##import numpy as np
import pandas as pd
import matplotlib.pyplot as plt
import seaborn as sns

##한글 폰트 깨짐 방지 
from matplotlib import font_manager, rc

font_path = "c:\\windows\\fonts\\malgun.ttf"
font_name = font_manager.FontProperties(fname=font_path).get_name()

rc('font', family=font_name)

##차트 크기(단위는 인치로 계산됨)
plt.figure(figsize=(5,4))


## data 분석 자료. 탑승 클래스(1,2,3등급) 별 생존자와 사망자 수 분석 자료 
df = pd.read_csv('../data/titanic.csv', encoding='euc-kr')

df_pclass11 = df[(df.Survived == 1) & (df.Pclass == 1)].count()
df_pclass12 = df[(df.Survived == 1) & (df.Pclass == 2)].count()
df_pclass13 = df[(df.Survived == 1) & (df.Pclass == 3)].count()

df_pclass01 = df[(df.Survived == 0) & (df.Pclass == 1)].count()
df_pclass02 = df[(df.Survived == 0) & (df.Pclass == 2)].count()
df_pclass03 = df[(df.Survived == 0) & (df.Pclass == 3)].count()

x1 = ['first', 'second', 'third']  ## x축이름 리스트 

survived_df = [df_pclass11.Pclass, df_pclass12.Pclass, df_pclass13.Pclass]
dead_df = [df_pclass01.Pclass, df_pclass02.Pclass, df_pclass03.Pclass]


pieColor=['pink','lightgreen','lightblue']
plt.pie(survived_df, autopct='%1.1f%%', radius=1.2, startangle=90, colors=pieColor,shadow=True,
        wedgeprops={'edgecolor':'k','linewidth': 0.5, 'linestyle': 'solid', 'antialiased': True})
plt.pie(dead_df, autopct='%1.1f%%', radius=0.6, startangle=90, colors=pieColor, shadow=True,
        wedgeprops={'edgecolor':'k','linewidth': 0.5, 'linestyle': 'solid', 'antialiased': True})
plt.legend(x1, loc='upper right')
plt.title('탑승클래스별 생존자와 사망자', fontsize='10')

plt.show()
